#include "Timer.h"

Timer::Timer()
{
#ifdef WINDOWS
    beg_ = GetTickCount();
#endif
#ifdef POSIX
    clock_gettime(CLOCK_REALTIME, &beg_);
#endif
}

double Timer::elapsed()
{
#ifdef WINDOWS
    end_ = GetTickCount();
    return end_ - beg_;
#endif
#ifdef POSIX
   clock_gettime(CLOCK_REALTIME, &end_);
   return end_.tv_sec - beg_.tv_sec +
       (end_.tv_nsec - beg_.tv_nsec) / 1000000000.;
#endif
}

void Timer::reset()
{
#ifdef WINDOWS
    beg_ = GetTickCount();
#endif
#ifdef POSIX
    clock_gettime(CLOCK_REALTIME, &beg_);
#endif
}
